import { Button } from '@/components/UI/Button';
import { Container } from '@/components/UI/Container';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import FuelGraphic from '@/pagesComponents/Statistics/Fuel/components/FuelGraphic';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import { choiceTimeOptions } from '@/pagesComponents/Statistics/constants';
import { durationOptions } from '@/pagesComponents/Statistics/Fuel/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Компания', key: 'company' },
  { name: 'Время', key: 'time' },
  { name: 'Топливо', key: 'fuel' },
  { name: 'Основной бак', key: 'main_tank' },
  { name: 'Дополнительный бак', key: 'additional_tank' },
  { name: 'Пробег', key: 'mileage' },
  { name: 'Скорость', key: 'speed' },
  { name: 'Координаты', key: 'coordinates' },
];

const graphicIndicators = [
  { name: 'Топливо', bg: 'bg-[#FF8C00]' },
  { name: 'Масло', bg: 'bg-[#FFB55F]' },
  { name: 'Скорость', bg: 'bg-[#1E90FF]' },
  { name: 'Пробег', bg: 'bg-[#9400D3]' },
];

const refuelingOptions = [
  { label: '5L', value: '5l' },
  { label: '10L', value: '10l' },
  { label: '15L', value: '15l' },
  { label: '20L', value: '20l' },
  { label: '30L', value: '30l' },
  { label: '40L', value: '40l' },
  { label: '50L', value: '50l' },
];

const FuelConsumptionChart = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>
          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Промежуток:'
            placeholder='0(км)'
            classes={{ root: 'max-w-[320px]' }}
            options={durationOptions}
          />
          <Select
            label='Изменения (дозаправка):'
            placeholder='20 литров'
            classes={{ root: 'max-w-[320px]' }}
            options={refuelingOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <Container>
        <FuelGraphic title='График топлива/скорости' indicators={graphicIndicators} />
      </Container>

      <TableWrapper className='mt-10'>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default FuelConsumptionChart;
