'use client';
import { useSearchParams } from 'next/navigation';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import Main from './Main';
import DetailedReport from './DetailedReport';

const widgets = {
  '': {
    title: 'Количество срабатываний',
    component: <Main />,
  },
  detailed_report: {
    title: 'Подробный отчет',
    component: <DetailedReport />,
  },
};

const AlarmsForIoSensor = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';

  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/alarms_for_io_sensor',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default AlarmsForIoSensor;
