'use client';

import { useSearchParams } from 'next/navigation';
import { useDeterminateWidget } from '@/pagesComponents/Statistics/utils/useDeterminateWidget';
import StatisticsLayout from '@/pagesComponents/Statistics/components/StatisticsLayout';
import Main from './Main';
import KeyDisturbingRequest from './KeyDisturbingRequest';
import DetailedReport from './DetailedReport';

const widgets = {
  '': {
    title: 'Количество тревог',
    component: <Main />,
  },
  key_disturbing_request: {
    title: 'Ключевой тревожный запрос',
    component: <KeyDisturbingRequest />,
  },
  detailed_report: {
    title: 'Подробный отчёт',
    component: <DetailedReport />,
  },
};

const Alarms = () => {
  const searchParams = useSearchParams();
  const activeWidget = searchParams.get('widget') || '';
  const { widget } = useDeterminateWidget({
    activeWidget,
    redirectLink: '/statistics/alarms',
    widgets,
  });

  return <StatisticsLayout title={widget.title}>{widget.component}</StatisticsLayout>;
};

export default Alarms;
