import { Button } from '@/components/UI/Button';
import { Select } from '@/components/UI/Select';
import Table from '@/components/UI/Table';
import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import StatisticsFiltersForm from '@/pagesComponents/Statistics/components/StatisticsFiltersForm';
import TableWrapper from '@/pagesComponents/Statistics/components/TableWrapper';
import StatisticsFilterWrapper from '@/pagesComponents/Statistics/components/StatisticsFilterWrapper';
import {
  choiceTimeOptions,
  proccesingStatusOptions,
  typeChoiceOptions,
} from '@/pagesComponents/Statistics/constants';
import { Input } from '@/components/UI/Input';
import { selectOptions } from '@/pagesComponents/Statistics/Alarms/constants';
import ChoosingTransport from '@/pagesComponents/Statistics/components/ChoosingTransportWrapper';

const headHeadings = [
  { name: 'Номер', key: 'number' },
  { name: 'Операции', key: 'operations' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'number_color' },
  { name: 'Контакты', key: 'contacts' },
  { name: 'Телефон', key: 'phone_number' },
  { name: 'Тип тревоги', key: 'alarm_type' },
  { name: 'Источник тревоги', key: 'alarm_source' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'ending' },
  { name: 'Длительность тревоги', key: 'alarm_duration' },
  { name: 'Начальная скорость', key: 'start_speed' },
  { name: 'Конечная скорость', key: 'end_speed' },
  { name: 'Начальное положение', key: 'start_place' },
  { name: 'Конечное местоположение', key: 'end_place' },
  { name: 'Информ.тревоги', key: 'alarm_info' },
  { name: 'Статус отчёта', key: 'report_status' },
  { name: 'Статус обработки', key: 'processing_status' },
  { name: 'Обработавший пользователь', key: 'processed_user' },
  { name: 'Содержание обработки', key: 'processing_content' },
  { name: 'Способ обработки', key: 'processing_method' },
  { name: 'Время обработки', key: 'processing_time' },
];

const KeyDisturbingRequest = () => {
  return (
    <>
      <StatisticsFilterWrapper>
        <StatisticsFiltersForm>
          <Select
            label='Выбор времени:'
            placeholder='Настроить своё'
            classes={{ root: 'max-w-[320px]' }}
            options={choiceTimeOptions}
          />
          <DatepickerWithInput
            label='Время начала:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <DatepickerWithInput
            label='Время окончания:'
            placeholder='00:00:00'
            className='max-w-[320px]'
          />
          <Button type='submit' className='max-w-[190px] mt-5'>
            Запрос
          </Button>

          <Select
            label='Report Status:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={selectOptions.reportStatus}
          />
          <Select
            label='Статус обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={proccesingStatusOptions}
          />
          <Select
            label='Способ обработки:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={selectOptions.processingMethod}
          />
          <Select
            label='Источник тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={selectOptions.alarmSource}
          />
          <Select
            label='Тип тревоги:'
            placeholder='Все'
            classes={{ root: 'max-w-[320px]' }}
            options={selectOptions.alarmType}
          />
          <Input
            label='Длительность тревоги:'
            placeholder='в секундах'
            className='max-w-[320px]'
            wrapperInputClassName='h-[56px]'
          />

          <ChoosingTransport label='Транспорт:' placeholder='Все' className='max-w-[320px]' />
          <Select
            label='Выбор типа:'
            placeholder='Номер задания'
            classes={{ root: 'max-w-[320px]' }}
            options={typeChoiceOptions}
          />
        </StatisticsFiltersForm>
      </StatisticsFilterWrapper>

      <TableWrapper>
        <Table headHeadings={headHeadings} />
      </TableWrapper>
    </>
  );
};

export default KeyDisturbingRequest;
