'use client';
import moment from 'moment';
import { useMemo } from 'react';
import { useQuery } from '@tanstack/react-query';
import Icon from '@/components/Icon';
import Operations from '@/components/Operations';
import { Button } from '@/components/UI/Button';
import { Input } from '@/components/UI/Input';
import TableLoading from '@/components/UI/Loaders/TableLoading';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import { allOperations } from '@/pagesComponents/Settings/constants';
import { UserService } from '@/services/Settings/UserService';

const headHeadings = [
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={allOperations} />;
    },
  },
  { name: 'Вход в аккаунт', key: 'enter_to_account' },
  { name: 'Номер', key: 'number' },
  { name: 'Имя', key: 'name' },
  { name: 'Компания', key: 'company' },
  { name: 'Правильность', key: 'accuracy' },
  { name: 'Статус', key: 'status' },
  { name: 'Время обновления', key: 'update_time' },
  { name: 'Идентификация', key: 'identification' },
  { name: 'Предприятие', key: 'firm' },
  { name: 'Почта', key: 'mail' },
  { name: 'Предыдущий отдел', key: 'previous_department' },
  { name: 'Контакт', key: 'contact' },
  { name: 'Права доступа к ролям', key: 'access_rights_to_roles' },
];

const User = () => {
  // const { data: usersOnlineData, isPending: usersOnlinePending } = useQuery({
  //   queryKey: ['onlineUsersCount'],
  //   queryFn: () => UserService.getOnlineUsersCount(),
  // });

  const { data, isPending, refetch, isFetching } = useQuery({
    queryKey: ['users'],
    queryFn: () => UserService.getUsers(),
  });

  const tableData = useMemo((): TableData[] | undefined => {
    if (data?.data.infos.length) {
      const users = data.data.infos;
      return users.map((user, index) => {
        return {
          id: user.id,
          enter_to_account: user.nm,
          number: index + 1,
          company: user.nm,
          accuracy: '',
          status: 'Использовать',
          update_time: moment(user.utm).format('YYYY-MM-DD HH:mm:ss'),
        };
      });
    }
    return;
  }, [data?.data?.infos]);

  return (
    <div className='flex flex-col gap-6'>
      <div className='flex items-center gap-5'>
        <Input
          placeholder='Поиск'
          wrapperInputClassName='h-[56px] min-w-[283px]'
          icon={
            <Icon
              src='/images/icons/icon-search.svg'
              className='size-[21px] min-w-[21px] text-primary mr-4'
            />
          }
        />
        <Button background='black' className='!min-w-[180px]' onClick={() => refetch()}>
          Все пользователи
        </Button>
        <Button variant='green_outlined' className='!min-w-[196px]'>
          Пользователь в сети
        </Button>
        <Button background='green'>Добавить</Button>
        <Button variant='gray_outlined'>Импорт Excel</Button>
        <Button variant='gray_outlined'>User Vehicle Import</Button>
        <Button variant='gray_outlined'>Excel</Button>
      </div>

      {isPending ? (
        <TableLoading />
      ) : (
        <Table isLoading={isFetching} headHeadings={headHeadings} data={tableData || []} />
      )}
    </div>
  );
};

export default User;
