'use client';
import { useQuery } from '@tanstack/react-query';
import { FC, useMemo } from 'react';
import { TransportService } from '@/services/Settings/TransportService';

const TransportViewModal: FC<{ transportId: number }> = ({ transportId }) => {
  const { data, isPending } = useQuery({
    queryKey: ['transportViewModal', transportId],
    queryFn: () => TransportService.getTransportById(transportId),
  });

  const basicInformationList = useMemo(() => {
    if (data?.data?.result === 0) {
      const vehicle = data.data.vehicle;
      return [
        { key: 'Госномер', value: vehicle.vehiIDNO },
        { key: 'Цвет транспорта', value: '' },
        { key: 'Компания', value: '' },
        { key: 'Agent', value: '' },
        { key: 'Сокращение', value: '' },
        { key: 'Дата запуска сервиса', value: '' },
        { key: 'Дата установки', value: '' },
        { key: 'Vehicle Type II', value: '' },
        { key: 'Марка', value: '' },
        { key: 'Класс автомобиля', value: '' },
        { key: 'Статус использования', value: '' },
        { key: 'Дата ежегодного тех.осмотра', value: '' },
        { key: 'Порог ограничения скорости', value: '' },
        { key: 'Хранение GPS данных (день)', value: '' },
        { key: 'Авторизация гос.номера', value: '' },
      ];
    }
    return undefined;
  }, [data?.data]);

  if (isPending) {
    return <p>Загрузка....</p>;
  }

  return (
    <div>
      {basicInformationList && basicInformationList.length > 0 && (
        <ul>
          {basicInformationList.map((item) => (
            <li key={item.key} className='flex items-center gap-2'>
              <p>{item.key}</p>
              <p>{item.value}</p>
            </li>
          ))}
        </ul>
      )}
    </div>
  );
};

export default TransportViewModal;
