import { FC, useState } from 'react';
import Tabs from '@/components/Tabs';
import { ITab } from '@/components/Tabs/Tabs';
import AddOne from './AddOne';
import AddSeveral from './AddSeveral';

const tabs: ITab[] = [
  { key: 'one', title: 'Добавить один' },
  { key: 'several', title: 'Добавить несколько' },
] as const;

type TabKeys = (typeof tabs)[number]['key'];

const FastAddTransportModal: FC<{ onClose: () => void }> = ({ onClose }) => {
  const [activeTab, setActiveTab] = useState<TabKeys>(tabs[0].key);

  return (
    <>
      <div className='flex justify-center items-center mb-6'>
        <Tabs tabs={tabs} onChange={(value) => setActiveTab(value)} value={activeTab} />
      </div>
      {activeTab === 'one' && <AddOne onClose={onClose} />}
      {activeTab === 'several' && <AddSeveral onClose={onClose} />}
    </>
  );
};

export default FastAddTransportModal;
