import { FC, type FormEvent } from 'react';
import { Button } from '@/components/UI/Button/Button';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import { Textarea } from '@/components/UI/Textarea';

const AddSeveral: FC<{ onClose: () => void }> = ({ onClose }) => {
  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
  };

  return (
    <form onSubmit={handleSubmit}>
      <div className='grid grid-cols-2 justify-between gap-10 mb-6'>
        <Input
          label={
            <>
              Device No<span className='text-[#E31717]'>*</span>:
            </>
          }
          placeholder='...'
        />
        <div className='flex items-center gap-[20px]'>
          <Input label='Начало:' />
          <Input label='Конец:' />
        </div>

        <p className='text-[#7D7D7D]'>
          (Без последних четырех цифр, например для CX051234 введите CX05)
        </p>
        <div />

        <Input label='Серийный №:' placeholder='...' />
        <Select label='Тип протокола:' placeholder='...' />
        <Select label='Тип завода:' placeholder='...' />
        <Select label='Иконка:' placeholder='...' />
        <Select label='Тип терминала:' placeholder='...' />
        <Input label='Модель:' placeholder='...' />
        <Select label='Параметры каналов:' placeholder='...' />

        <Select label='Компания/Автоколонна:' placeholder='...' />
        <Select label='Принадлежность пользователю:' placeholder='...' />
        <div />
      </div>

      <Textarea label='Примечание:' placeholder='...' />

      <div className='flex justify-center items-center gap-4 mt-10'>
        <Button variant='gray_outlined' onClick={onClose} className='max-w-max'>
          Закрыть
        </Button>
        <Button type='submit' className='max-w-max'>
          Сохранить
        </Button>
      </div>
    </form>
  );
};

export default AddSeveral;
