import { FC, type FormEvent } from 'react';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import { Textarea } from '@/components/UI/Textarea';
import { Button } from '@/components/UI/Button';
import {
  channelOptions,
  colorOptions,
  firmTypeOptions,
  protocolTypeOptions,
  terminalTypeOptions,
} from './constants';

const AddOne: FC<{ onClose: () => void }> = ({ onClose }) => {
  const handleSubmit = (e: FormEvent) => {
    e.preventDefault();
  };

  return (
    <form onSubmit={handleSubmit}>
      <div className='grid grid-cols-2 justify-between gap-10 mb-6'>
        <Input
          label={
            <>
              Device No<span className='text-[#E31717]'>*</span>:
            </>
          }
          placeholder='...'
        />
        <Select label='Цвет номерного знака' placeholder='...' options={colorOptions} />

        <Input
          label={
            <>
              Госномер<span className='text-[#E31717]'>*</span>:
            </>
          }
          placeholder='...'
        />
        <Select label='Тип протокола:' placeholder='...' options={protocolTypeOptions} />
        <Input label='Номер SIM карты:' placeholder='...' />
        <Select label='Тип завода:' placeholder='...' options={firmTypeOptions} />
        <Input label='Серийный №:' placeholder='...' />
        <Select label='Иконка:' placeholder='...' />
        <Select label='Тип терминала:' options={terminalTypeOptions} placeholder='...' />
        <Input label='Модель:' placeholder='...' />
        <Select label='Параметры каналов:' placeholder='...' options={channelOptions} />

        <Select label='Компания/Автоколонна:' placeholder='...' />
        <Select label='Принадлежность пользователю:' placeholder='...' />
        <div />
      </div>

      <Textarea label='Примечание:' placeholder='...' />

      <div className='flex justify-center items-center gap-4 mt-10'>
        <Button variant='gray_outlined' onClick={onClose} className='max-w-max'>
          Закрыть
        </Button>
        <Button type='submit' className='max-w-max'>
          Сохранить
        </Button>
      </div>
    </form>
  );
};

export default AddOne;
