import type { IOption } from '@/types/IOption';

export const colorOptions: IOption[] = [
  { label: 'Желтый', value: 'yellow' },
  { label: 'Черный', value: 'black' },
  { label: 'Белый', value: 'white' },
  { label: 'Green Card', value: 'green_card' },
  { label: 'Yellow Green Card', value: 'yellow_green_card' },
  { label: 'Yellow Green CardFJ', value: 'yellow_green_card_fj' },
  { label: 'White Green CardFJ', value: 'white_green_card_fj' },
  { label: 'Agricultural Yellow Card', value: 'agricultural_yellow_card' },
  { label: 'Agro Green Card', value: 'agro_green_card' },
  { label: 'Gradual Green Card', value: 'gradual_green_card' },
  { label: 'Нет', value: 'no' },
  { label: 'Другое', value: 'other' },
];

export const protocolTypeOptions: IOption[] = [
  { label: 'Standard 1078(Tian Jin)', value: 'standard_1078' },
  { label: 'Bu Biao Active Safety(883)', value: 'bu_biao_active_safety' },
  { label: 'Standard Active Safety(Beijing)', value: 'standard_active_safety' },
  {
    label: 'Ministry Standard Active Safety (Jiangsu)(2023)',
    value: 'ministry_standard_active_safety',
  },
  { label: '905(2014)', value: '905_2014' },
  { label: '905(2020)', value: '905_2020' },
  { label: '905(Beijing)', value: '905_beijing' },
  { label: '28181(2011)', value: '28181_2011' },
  { label: '28181(2016)', value: '28181_2016' },
  { label: 'Неизвестный', value: 'unknown' },
];

export const firmTypeOptions: IOption[] = [
  { label: 'Неизвестный', value: 'unknown' },
  { label: 'RM(29)', value: 'rm' },
  { label: 'HK(26)', value: 'hk' },
  { label: 'HB(23)', value: 'hb' },
  { label: 'BSJ(24)', value: 'bsj' },
  { label: 'TL(16)', value: 'tl' },
  { label: 'TJ(27)', value: 'tj' },
  { label: 'RCM(14)', value: 'rcm' },
  { label: 'YJW(7)', value: 'yjw' },
  { label: 'DW(2)', value: 'dw' },
  { label: 'ZY(70)', value: 'zy' },
  { label: 'BSD(71)', value: 'bsd' },
  { label: 'HT(10)', value: 'ht' },
  { label: 'HD(20)', value: 'hd' },
  { label: 'YW(9)', value: 'yw' },
  { label: 'SF(11)', value: 'sf' },
  { label: 'EST(4)', value: 'est' },
  { label: 'YX(28)', value: 'yx' },
  { label: 'FZE(21)', value: 'fze' },
  { label: 'YA(30)', value: 'ya' },
  { label: 'GM(17)', value: 'gm' },
  { label: 'RTP(42)', value: 'rtp' },
  { label: 'BA(32)', value: 'ba' },
  { label: 'ZTAC(81)', value: 'ztac' },
  { label: 'QM(82)', value: 'qm' },
  { label: 'SH(83)', value: 'sh' },
  { label: 'XH(84)', value: 'xh' },
];

export const terminalTypeOptions: IOption[] = [
  { value: 'Терминал местоположения', label: 'placement_terminal' },
  { value: 'Видеотерминал', label: 'videoterminal' },
  { value: 'Main defense terminal', label: 'main_defense_terminal' },
];

export const channelOptions: IOption[] = new Array(16).fill('').map((_, index) => {
  return {
    label: `ch${index + 1}`,
    value: `ch${index + 1}`,
  };
});
