import type { FC } from 'react';
import Accordion from '@/components/UI/Accordion';
import { Button } from '@/components/UI/Button';
import BasicInformation from './BasicInformation';
import DeviceInfo from './DeviceInfo';
import InstallationEquipmentInformation from './InstallationEquipmentInformation';
import DocumentInfo from './DocumentInfo';
import TechnicalParameters from './TechnicalParameters';
import CurrentVehicle from './CurrentVehicle';
import PurchaseRegistation from './PurchaseRegistration';
import CustomMenu from './CustomMenu';

interface AddTransportModalProps {
  onClose: () => void;
}

const AddTransportModal: FC<AddTransportModalProps> = ({ onClose }) => {
  return (
    <form>
      <Accordion title='Основная информация' defaultOpen>
        <div className='py-6 px-[56px]'>
          <BasicInformation />
        </div>
      </Accordion>
      <Accordion title='Информация об устройстве'>
        <div className='py-6 px-[56px]'>
          <DeviceInfo />
        </div>
      </Accordion>
      <Accordion title='Информация об установке оборудования'>
        <div className='py-6 px-[56px]'>
          <InstallationEquipmentInformation />
        </div>
      </Accordion>
      <Accordion title='Информация о документах'>
        <div className='py-6 px-[56px]'>
          <DocumentInfo />
        </div>
      </Accordion>
      <Accordion title='Технические параметры'>
        <div className='py-6 px-[56px]'>
          <TechnicalParameters />
        </div>
      </Accordion>
      <Accordion title='Действующее ТС'>
        <div className='py-6 px-[56px]'>
          <CurrentVehicle />
        </div>
      </Accordion>
      <Accordion title='Регистрация покупки'>
        <div className='py-6 px-[56px]'>
          <PurchaseRegistation />
        </div>
      </Accordion>
      <Accordion title='Custom Menu'>
        <div className='py-6 px-[56px]'>
          <CustomMenu />
        </div>
      </Accordion>

      <div className='flex items-center justify-center gap-4 mt-10 mb-6'>
        <Button variant='gray_outlined' onClick={onClose} className='max-w-max'>
          Закрыть
        </Button>
        <Button type='submit' className='max-w-max'>
          Сохранить
        </Button>
      </div>
    </form>
  );
};

export default AddTransportModal;
