import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import { statusCheckboxOptions } from './constants';

const InstallationEquipmentInformation = () => {
  return (
    <>
      <p>Статус:</p>
      <ul className='flex flex-wrap mt-6 mb-8 gap-[56px]'>
        {statusCheckboxOptions.map((status) => (
          <li key={status.value}>
            <Checkbox isActive={false} value={status.value} label={status.label} />
          </li>
        ))}
      </ul>

      <div className='grid grid-cols-4 gap-6'>
        <Input label='TPMS Марка:' placeholder='...' />
        <Input label='TPMS Модель:' placeholder='...' />
        <Input label='ADAS Марка:' placeholder='...' />
        <Input label='ADAS Модель:' placeholder='...' />
        <Input label='DSM Марка:' placeholder='...' />
        <Input label='DSM Модель:' placeholder='...' />
        <Input label='BSD Марка:' placeholder='...' />
        <Input label='BSD Модель:' placeholder='...' />
        <Input label='Система помощи при смене полосы:' placeholder='...' />
        <Input label='Модель помощи при смене полосы:' placeholder='...' />
        <Input label='Одна марка машины:' placeholder='...' />
        <Input label='Одна модель машины:' placeholder='...' />
        <Input label='Установщик:' placeholder='...' />
        <Input label='Телефон установщика:' placeholder='...' />
        <Input label='Оборудование для школьного автобуса:' placeholder='...' />
      </div>
    </>
  );
};

export default InstallationEquipmentInformation;
