import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import {
  alarmEnterIoOptions,
  alarmSignOutIoOptions,
  channelOptions,
  peripheralModules,
  temperatureSensorOptions,
  terminalTypeOptions,
} from './constants';

const DeviceInfo = () => {
  return (
    <>
      <div className='grid grid-cols-4 gap-6'>
        <Input
          label={
            <>
              Номер устройства<span className='text-[#E31717]'>*</span>:
            </>
          }
        />
        <Input label='Номер SIM карты' />
        <Input label='Фактический номер SIM-карты:' />
        <Select label='Тип терминала:' options={terminalTypeOptions} />
        <Select label='Параметры каналов:' options={channelOptions} />
        <Select label='Тревожные входы IO:' options={alarmEnterIoOptions} />
        <Select label='Тревожные выходы IO:' options={alarmSignOutIoOptions} />
        <Select label='Температурный датчик:' options={temperatureSensorOptions} />
      </div>

      <p className='my-6'>Переферийные модули:</p>
      <ul className='grid grid-cols-4 gap-[30px]'>
        {peripheralModules.map((module) => (
          <li key={module.value}>
            <Checkbox value={module.value} label={module.label} isActive={false} />
          </li>
        ))}
      </ul>
    </>
  );
};

export default DeviceInfo;
