import type { IOption } from '@/types/IOption';

export const peripheralModules = [
  { label: 'Поддержка видео', value: 'video_support' },
  { label: 'Основной бензовоз', value: 'main_fuel_tanker' },
  { label: 'OBD', value: 'obd' },
  { label: 'Датчик веса', value: 'weight_sensor' },
  { label: 'Поддержка обратной связи', value: 'feedback_support' },
  { label: 'Дополнительный бак', value: 'additional_tank' },
  { label: 'Статистика движения', value: 'traffic_statistics' },
  { label: 'Датчик уровня жидкости', value: 'liquid_level_sensor' },
  { label: 'Поддержка наблюдения', value: 'surveillance_support' },
  {
    label: 'Топливный контроллер (отключение топлива и рекуперация топлива',
    value: 'fuel_controller',
  },
  { label: 'Система контроля давления в шинах', value: 'control_system' },
  { label: 'Датчик температуры жидкости', value: 'temperature_sensor' },
  { label: 'TTS (Воспроизведение голоса TTS)', value: 'tts' },
  { label: 'Контроллер цепи (цепь отключения и цепь восстановления)', value: 'chain_controller' },
  { label: 'Таксометр', value: 'taxometer' },
  { label: 'Электронный замок', value: 'electronic_lock' },
];

export const terminalTypeOptions: IOption[] = [
  { label: 'Терминал местоположения', value: 'terminal_placement' },
  { label: 'Видеотерминал', value: 'video_terminal' },
  { label: 'Main defense terminal', value: 'main_defense_terminal' },
];

export const channelOptions: IOption[] = new Array(16).fill('').map((_, index) => {
  return {
    label: `${index + 1}`,
    value: `${index + 1}`,
  };
});

export const alarmEnterIoOptions: IOption[] = new Array(16).fill('').map((_, index) => {
  return {
    label: `${index + 1}`,
    value: `${index + 1}`,
  };
});

export const alarmSignOutIoOptions: IOption[] = new Array(16).fill('').map((_, index) => {
  return {
    label: `${index + 1}`,
    value: `${index + 1}`,
  };
});

export const temperatureSensorOptions: IOption[] = new Array(16).fill('').map((_, index) => {
  return {
    label: `${index + 1}`,
    value: `${index + 1}`,
  };
});
