import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import { Textarea } from '@/components/UI/Textarea';
import { IOption } from '@/types/IOption';

const countUserMenuOptions: IOption[] = new Array(10).fill('').map((_, index) => {
  return {
    label: `Путь${index + 1}`,
    value: `${index + 1}`,
  };
});

const CustomMenu = () => {
  return (
    <>
      <Select
        label='Количество пользовательских меню:'
        options={countUserMenuOptions}
        classes={{ root: 'max-w-[320px]' }}
      />

      <div className='grid grid-cols-2 gap-6 my-6'>
        <Input label='Путь 1' placeholder='...' />
        <Input label='Путь 2' placeholder='...' />
        <Input label='Путь 3' placeholder='...' />
        <Input label='Путь 4' placeholder='...' />
        <Input label='Путь 5' placeholder='...' />
      </div>

      <Textarea />
    </>
  );
};

export default CustomMenu;
