import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import { categoryTransportBranchOptions, vehicleTypeOptions } from './constants';

const CurrentVehicle = () => {
  return (
    <div className='grid grid-cols-4 gap-6'>
      <Input label='Номер лицензии на эксплуатацию:' placeholder='...' />
      <Input label='Классовая принадлежность:' placeholder='...' />
      <Input label='Протяженность маршрута:' placeholder='...' />
      <Input label='Магистрали в эксплуатации:' placeholder='...' />
      <Input label='Код компании:' placeholder='...' />
      <DatepickerWithInput label='Срока действия рабочего периода:' placeholder='00.00.0000' />
      <Input label='Сфера деятельности:' placeholder='...' />
      <Input label='Business Mature:' placeholder='...' />
      <Input label='Область:' placeholder='...' />
      <Input label='Ядерное:' placeholder='...' />
      <Select
        label='Категория транспортной отрасли:'
        placeholder='...'
        options={categoryTransportBranchOptions}
      />
      <Select label='Тип транспортного средства:' placeholder='...' options={vehicleTypeOptions} />
      <Input label='Вес товара/Место происхождения:' placeholder='...' />
      <Input label='Наименование товара/Burst:' placeholder='...' />
      <Input label='Пункт отправления ТС:' placeholder='...' />
      <Input label='Пункт назначения ТС:' placeholder='...' />
      <Input label='Объем груза:' placeholder='...' />
    </div>
  );
};

export default CurrentVehicle;
