import DatepickerWithInput from '@/components/UI/DatepickerWithInput';
import { Input } from '@/components/UI/Input';
import { Select } from '@/components/UI/Select';
import { Textarea } from '@/components/UI/Textarea';
import { statusOptions, typeTransportOptions, typeTransportOptions2 } from './constants';

const BasicInformation = () => {
  return (
    <div className='grid grid-cols-4 gap-6'>
      <Input
        label={
          <>
            Госномер <span className='text-[#E31717]'>*</span>:
          </>
        }
      />
      <Select
        label={
          <>
            Цвет номерного знака <span className='text-[#E31717]'>*</span>:
          </>
        }
      />
      <Input label='Цвет транспорта' />
      <Input label='VIN номер' />
      <Select
        label={
          <>
            Компания <span className='text-[#E31717]'>*</span>:
          </>
        }
      />
      <Select label='Водитель:' />
      <Select label='Агент:' />
      <Select label='Сокращение:' />
      <DatepickerWithInput label='Последний сервис:' />
      <DatepickerWithInput label='Дата запуска сервиса:' />
      <DatepickerWithInput label='Дата установки:' />
      <div />
      <Select label='Тип транспорта:' options={typeTransportOptions} />
      <Select label='Тип транспорта 2:' options={typeTransportOptions2} />
      <Input label='Мануфактура:' />
      <Input label='Марка:' />
      <Input label='Модель транспорта:' />
      <Input label='Класс автомобиля:' />
      <Input label='Цели:' />
      <Select
        label={
          <>
            <>
              Статус использования <span className='text-[#E31717]'>*</span>:
            </>
          </>
        }
        options={statusOptions}
      />
      <DatepickerWithInput label='Scrap Date:' />
      <DatepickerWithInput label='Дата ежегодного тех.осмотра:' />
      <Select label='Иконка:' />
      <div />
      <Input
        label={
          <>
            Порог ограничения скорости <span className='text-[#E31717]'>*</span>:
          </>
        }
      />
      <Input
        label={
          <>
            Хранение GPS данных (день) <span className='text-[#E31717]'>*</span>:
          </>
        }
      />
      <Input label='Коэффициент пробега (%):' />
      <Select label='Авторизация гос.номера:' />
      <Textarea placeholder='...' />
    </div>
  );
};

export default BasicInformation;
