'use client';
import Icon from '@/components/Icon';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import Operations, { type OperationKeys } from '@/components/Operations';

const operations: OperationKeys = ['watch', 'copy', 'edit', 'remove'];

const headHeadings = [
  {
    name: <Checkbox isActive={false} value='all' />,
    key: 'ALL_CHECKBOXES',
    className: '[&_div]:justify-center',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Checkbox isActive={false} value={'1'} wrapperClassName='justify-center' />;
    },
  },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={operations} />;
    },
  },
  { name: 'Операции', key: 'operations' },
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Цвет номера', key: 'color_number' },
  { name: 'Транспортная карта', key: 'transport_card' },
  { name: 'Сфера деятельности', key: 'field_of_activity' },
  { name: 'Срок оценки тех.уровня ТС', key: 'term' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Календарь расписания', key: 'schedule_calendar' },
  { name: 'Business scope code', key: 'business_scope_code' },
  { name: 'Issuing authority', key: 'issuing_authority' },
  { name: 'Примечание', key: 'note' },
];

const TransporationCertificate = () => {
  return (
    <div className='flex flex-col gap-6'>
      <div className='flex items-center gap-5 [&_button]:max-w-max'>
        <Input
          className='w-[283px]'
          placeholder='Госномер'
          wrapperInputClassName='h-[56px]'
          icon={
            <Icon
              src='/images/icons/icon-search.svg'
              className='size-[21px] min-w-[21px] text-primary mr-4'
            />
          }
        />
        <Button background='green'>Добавить</Button>
        <Button variant='gray_outlined'>Импорт Excel</Button>
        <Button variant='gray_outlined'>Excel</Button>
      </div>

      <Table headHeadings={headHeadings} />
    </div>
  );
};

export default TransporationCertificate;
