'use client';
import { useQuery } from '@tanstack/react-query';
import { useMemo } from 'react';
import Icon from '@/components/Icon';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import Operations, { type OperationKeys } from '@/components/Operations';
import { ReminderAboutExpirationTimeService } from '@/services/Settings/ReminderAboutExpirationTimeService';
import TableLoading from '@/components/UI/Loaders/TableLoading';

const operations: OperationKeys = ['watch', 'copy', 'edit', 'remove'];

const headHeadings = [
  {
    name: <Checkbox isActive={false} value='all' />,
    key: 'ALL_CHECKBOXES',
    className: '[&_div]:justify-center',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Checkbox isActive={false} value={'1'} wrapperClassName='justify-center' />;
    },
  },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={operations} />;
    },
  },
  { name: 'Номер', key: 'number' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Компания', key: 'company' },
  { name: 'Цвет номера', key: 'color_number' },
  { name: 'Время истечения страховки', key: 'insurance_expiration_time' },
  { name: 'Истечение прав водителя', key: 'expiration_of_driver_license' },
  { name: 'Истечение лицензии опер.', key: 'expiration_of_operator_license' },
  { name: 'Время истечения', key: 'expiration_time' },
  { name: 'Срок ТО', key: 'technical_maintenance' },
  { name: 'Срок действия ТО в милях', key: 'to_mile' },
  { name: 'Обслуживание', key: 'service' },
  { name: 'Оценка тех.уровня ТО', key: 'tech_level_to' },
  { name: 'Срок действия SIM карты', key: 'validity_period_sim' },
  { name: 'Состояние', key: 'condition' },
  { name: 'Контакт', key: 'contact' },
  { name: 'Телефон', key: 'phone' },
  { name: 'Тип обслуживания', key: 'color_number' },
  { name: 'Тех.обслуживание', key: 'color_number' },
  { name: 'Начало', key: 'start' },
  { name: 'Окончание', key: 'end' },
  { name: 'Текущая цена', key: 'current_price' },
  { name: 'Календарь расписания', key: 'schedule_calendar' },
  { name: 'Примечание', key: 'note' },
  { name: 'Repaire fees(yuan)', key: 'repaire_fees' },
];

const ReminderAboutExpirationOfTime = () => {
  const { data, isPending } = useQuery({
    queryKey: ['getReminderAboutExpirationTime'],
    queryFn: () => ReminderAboutExpirationTimeService.getReminderAboutExpirationTime(),
  });

  const tableData = useMemo((): TableData[] | undefined => {
    if (data?.data.infos?.length) {
      const reminderAboutExpirationTime = data.data.infos;
      return reminderAboutExpirationTime.map((item, index) => {
        return {
          id: index,
          number: index + 1,
          gos_number: item.vehiIDNO,
          company: item.companyName,
          expiration_time: item.repair,
          insurance_expiration_time: item.safe,
          expiration_of_driver_license: item.driving,
          expiration_of_operator_license: item.operating,
          technical_maintenance: item.upkeepExpiredTime,
          service: item.service,
          validity_period_sim: item.sim,
        };
      });
    }
  }, [data?.data.infos]);

  return (
    <div className='flex flex-col gap-6'>
      <div className='flex items-center gap-5 [&_button]:max-w-max'>
        <Input
          className='max-w-[283px]'
          placeholder='Госномер'
          wrapperInputClassName='h-[56px] w-[283px]'
          icon={
            <Icon
              src='/images/icons/icon-search.svg'
              className='size-[21px] min-w-[21px] text-primary mr-4'
            />
          }
        />
        <Button background='green'>Добавить</Button>
        <Button variant='gray_outlined'>Excel</Button>
      </div>

      {isPending ? <TableLoading /> : <Table headHeadings={headHeadings} data={tableData || []} />}
    </div>
  );
};

export default ReminderAboutExpirationOfTime;
