'use client';
import { useState } from 'react';
import Icon from '@/components/Icon';
import Operations from '@/components/Operations';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import Modal from '@/components/UI/Modal';
import { Select } from '@/components/UI/Select';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import { allOperations } from '@/pagesComponents/Settings/constants';
import type { IOption } from '@/types/IOption';
import CreateDriverModal from './components/CreateDriverModal';

const headHeadings = [
  {
    name: <Checkbox isActive={false} value='all' />,
    key: 'ALL_CHECKBOXES',
    className: '[&_div]:justify-center',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Checkbox isActive={false} value={'1'} wrapperClassName='justify-center' />;
    },
  },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={allOperations} />;
    },
  },
  { name: 'Номер', key: 'number' },
  { name: 'Номер задания', key: 'task_number' },
  { name: 'Имя', key: 'name' },
  { name: 'Пол', key: 'floor' },
  { name: 'Контакт', key: 'contact' },
  { name: 'ID', key: 'id' },
  { name: 'Категория прав', key: 'category_of_rights' },
  { name: 'Время начала работы', key: 'start_time' },
  { name: 'Срок действия прав', key: 'validity_period_of_the_rights' },
  { name: 'Календарь расписания', key: 'datepicker_schedule' },
  { name: 'Компания', key: 'company' },
  { name: 'Номер лицензии', key: 'licences_number' },
  { name: 'Дата рождения', key: 'birthday_date' },
  { name: 'Обработанная дата выдачи лицензии', key: 'processed_date_of_the_license_issue' },
  { name: 'Совокупное время вождения', key: 'cumulative_driving_time' },
  { name: 'Совокупный пробег за рулём(км)', key: 'cumulative_driving_mileage' },
  { name: 'Grade', key: 'grade' },
  { name: 'Место рождения', key: 'birthday_place' },
  { name: 'Area', key: 'area' },
  { name: 'Nationality', key: 'nationality' },
  { name: 'Education level', key: 'education_level' },
  { name: 'Types_of_Qualification_Certificates', key: 'types_of_qualification_certificates' },
  { name: 'Supervision card number', key: 'supervision_card_number' },
  { name: 'Ядерное', key: 'nuclear' },
  { name: 'Госномер', key: 'gos_number' },
  { name: 'Цвет транспорта', key: 'transport_color' },
  { name: 'Модель транспорта', key: 'transport_model' },
  { name: 'Тип транспорта', key: 'transport_type' },
  { name: 'Адрес', key: 'address' },
  { name: 'Qualification Certificate Status', key: 'qualification_certificate_status' },
  { name: 'Driver`s Bank Card Number', key: 'drivers_bank_card_number' },
];

const typeOptions: IOption[] = [
  { label: 'Все', value: 'ALL' },
  { label: 'Имя водителя', value: 'driver_name' },
  { label: 'Компания', value: 'company' },
  { label: 'ID Card No', value: 'id_card_no' },
  { label: 'Госномер', value: 'gos_number' },
  { label: 'Тип транспорта', value: 'transport_type' },
  { label: 'Телефон', value: 'phone' },
  { label: 'Номер задания', value: 'task_number' },
  { label: 'Grade', value: 'grade' },
];

const DriverInfo = () => {
  const [isOpenCreateModal, setIsOpenCreateModal] = useState<boolean>(false);

  return (
    <>
      <div className='flex flex-col gap-6'>
        <div className='flex items-center gap-5'>
          <Select
            placeholder='Выбор типа'
            classes={{ root: 'min-w-[180px]' }}
            options={typeOptions}
          />
          <Input
            placeholder='Задайте чёткий запрос'
            wrapperInputClassName='h-[56px] min-w-[283px]'
            icon={
              <Icon
                src='/images/icons/icon-search.svg'
                className='size-[21px] min-w-[21px] text-primary mr-4'
              />
            }
          />
          <Button background='black'>Все водители</Button>
          <Button background='green' onClick={() => setIsOpenCreateModal(true)}>
            Добавить
          </Button>
          <Button variant='gray_outlined'>Импорт Excel</Button>
          <Button variant='gray_outlined'>Настройка экспорта</Button>
          <Button background='red'>Удалить</Button>
          <Button variant='gray_outlined'>Настройка импорта</Button>
        </div>

        <Table headHeadings={headHeadings} />
      </div>

      <Modal
        isOpen={isOpenCreateModal}
        closeModal={() => setIsOpenCreateModal(false)}
        className='max-w-[1464px]'
        title='Добавить информацию о водителе'
        bodyClassName='!p-0'
      >
        <CreateDriverModal onClose={() => setIsOpenCreateModal(false)} />
      </Modal>
    </>
  );
};

export default DriverInfo;
