import { FC } from 'react';
import Accordion from '@/components/UI/Accordion';
import { Button } from '@/components/UI/Button';
import BasicInformation from './BasicInformation';
import DocumentInfo from './DocumentInfo';
import RentCar from './RentCar';
import DocumentInfoAdditional from './DocumentInfoAdditional';

const CreateDriverModal: FC<{ onClose: () => void }> = ({ onClose }) => {
  return (
    <form>
      <Accordion title='Основная информация' defaultOpen>
        <div className='py-6 px-[56px]'>
          <BasicInformation />
        </div>
      </Accordion>
      <Accordion title='Информация о документах'>
        <div className='py-6 px-[56px]'>
          <DocumentInfo />
        </div>
      </Accordion>
      <Accordion title='Аренда и онлайн-вызов автомобилей'>
        <div className='py-6 px-[56px]'>
          <RentCar />
        </div>
      </Accordion>
      <Accordion title='Информация о документах'>
        <div className='py-6 px-[56px]'>
          <DocumentInfoAdditional />
        </div>
      </Accordion>

      <div className='flex items-center justify-center gap-4 mt-10 mb-6'>
        <Button variant='gray_outlined' onClick={onClose} className='max-w-max'>
          Закрыть
        </Button>
        <Button type='submit' className='max-w-max'>
          Сохранить
        </Button>
      </div>
    </form>
  );
};

export default CreateDriverModal;
