'use client';
import Icon from '@/components/Icon';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';

const Convoy = () => {
  return (
    <div className='flex flex-col gap-6'>
      <div className='flex items-center gap-5'>
        <Button background='green'>Добавить автоколонну</Button>
        <Button>Изменить автоколонну</Button>
        <Button background='red'>Удалить автоколонну</Button>
        <Button variant='gray_outlined'>Переместить автоколонну</Button>
        <Button variant='gray_outlined'>Импорт Excel</Button>
      </div>

      <section className='flex gap-4'>
        <div>
          <div className='flex justify-between items-center mb-4'>
            <h3 className='text-2xl leading-7 font-medium text-[#15223C]'>Список компаний</h3>
            <h3 className='text-2xl leading-7 font-medium text-[#15223C]'>Присвоенный транспорт</h3>
          </div>
          <div className='border rounded-2xl border-light_gray flex'>
            <div className='bg-[#F5F6FA] rounded-2xl p-4 min-w-[340px]'>
              <Input
                placeholder='Найти компанию'
                wrapperInputClassName='h-[56px]'
                icon={
                  <Icon
                    src='/images/icons/icon-search.svg'
                    className='size-[21px] min-w-[21px] text-primary mr-4'
                  />
                }
              />
            </div>
            <div className='bg-white p-4 rounded-2xl'>
              <Input
                placeholder='Найти транспорт'
                wrapperInputClassName='h-[56px]'
                icon={
                  <Icon
                    src='/images/icons/icon-search.svg'
                    className='size-[21px] min-w-[21px] text-primary mr-4'
                  />
                }
              />
              <ul className='mt-4 flex flex-col gap-3'>
                {new Array(4).fill('').map((_, index) => (
                  <li key={index} className='flex items-center'>
                    <Checkbox isActive={false} value={index.toString()} />
                    <p className='text-[16px] leading-[19px] text-center w-[140px]'>Номер</p>
                    <p className='text-[16px] leading-[19px] text-center w-[140px]'>Госномер</p>
                    <p className='text-[16px] leading-[19px] text-center w-[140px]'>Компания</p>
                  </li>
                ))}
              </ul>
            </div>
          </div>
        </div>

        <div className='flex flex-col gap-[10px] justify-center items-center'>
          <Button variant='gray_outlined'>Переместить в автоколонну</Button>
          <Button variant='gray_outlined'>Не в автоколонне</Button>
        </div>

        <div className='bg-white p-4 rounded-2xl border border-light_gray'>
          <Input
            placeholder='Найти транспорт'
            wrapperInputClassName='h-[56px]'
            icon={
              <Icon
                src='/images/icons/icon-search.svg'
                className='size-[21px] min-w-[21px] text-primary mr-4'
              />
            }
          />
          <ul className='mt-4 flex flex-col gap-3'>
            {new Array(4).fill('').map((_, index) => (
              <li key={index} className='flex items-center'>
                <Checkbox isActive={false} value={index.toString()} />
                <p className='text-[16px] leading-[19px] text-center w-[140px]'>Номер</p>
                <p className='text-[16px] leading-[19px] text-center w-[140px]'>Госномер</p>
                <p className='text-[16px] leading-[19px] text-center w-[140px]'>Компания</p>
              </li>
            ))}
          </ul>
        </div>
      </section>
    </div>
  );
};

export default Convoy;
