'use client';
import Icon from '@/components/Icon';
import Operations from '@/components/Operations';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import { Input } from '@/components/UI/Input';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import { allOperations } from '@/pagesComponents/Settings/constants';

const headHeadings = [
  {
    name: <Checkbox isActive={false} value='all' />,
    key: 'ALL_CHECKBOXES',
    className: '[&_div]:justify-center',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Checkbox isActive={false} value={'1'} wrapperClassName='justify-center' />;
    },
  },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={allOperations} />;
    },
  },
  { name: 'Операции', key: 'operations' },
  { name: 'Номер', key: 'number' },
  { name: 'Имя административной области', key: 'area_name' },
  { name: 'Административный код города', key: 'city_code' },
  { name: 'Имя зоны', key: 'zone_name' },
];

const Companies = () => {
  return (
    <div className='flex flex-col gap-6'>
      <div className='flex items-center gap-5 [&_button]:max-w-max'>
        <Input
          className='w-[283px]'
          placeholder='Область поиска'
          wrapperInputClassName='h-[56px]'
          icon={
            <Icon
              src='/images/icons/icon-search.svg'
              className='size-[21px] min-w-[21px] text-primary mr-4'
            />
          }
        />
        <Button background='black'>Все отделы</Button>
        <Button background='green'>Добавить</Button>
        <Button variant='gray_outlined'>Excel</Button>
      </div>

      <Table headHeadings={headHeadings} />
    </div>
  );
};

export default Companies;
