'use client';
import { Button } from '@/components/UI/Button';
import { Checkbox } from '@/components/UI/Checkbox';
import Table, { type TableData, TableDataColumn } from '@/components/UI/Table';
import Operations, { type OperationKeys } from '@/components/Operations';

const operations: OperationKeys = ['watch', 'copy', 'edit', 'remove'];

const headHeadings = [
  {
    name: <Checkbox isActive={false} value='all' />,
    key: 'ALL_CHECKBOXES',
    className: '[&_div]:justify-center',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Checkbox isActive={false} value={'1'} wrapperClassName='justify-center' />;
    },
  },
  {
    name: 'Операции',
    key: 'operations',
    renderColumn: (_column: TableDataColumn, _rowData: TableData) => {
      return <Operations operationKeys={operations} />;
    },
  },
  { name: 'Операции', key: 'operations' },
  { name: 'Номер', key: 'number' },
  { name: 'Фото', key: 'photo' },
  { name: 'Ссылка', key: 'link' },
  { name: 'Сортировка', key: 'sorting' },
  { name: 'Позиция', key: 'position' },
];

const BannerManagement = () => {
  return (
    <div className='flex flex-col gap-6'>
      <Button background='green' className='max-w-max'>
        Добавить
      </Button>

      <Table headHeadings={headHeadings} />
    </div>
  );
};

export default BannerManagement;
