'use client';
import { FC, useRef } from 'react';
import { IRecord } from '@/queries/records.interfaces';

export interface ITimelineTableProps {
  tracks: IRecord[][];
  options?: {
    trackNames?: string[];
  };
  hoursCount?: number;
  onAddVideo: (rec: IRecord) => void;
}

export const TimelineTable: FC<ITimelineTableProps> = ({ tracks, options, onAddVideo, hoursCount = 25 }) => {
  const tableRef = useRef<HTMLDivElement>(null);

  return (
    <div
      className='border-t-[1px] border-[#E6E9EE] overflow-x-auto max-w-[calc(100vw-510px)] flex flex-col scrollbar'
      ref={tableRef}
    >
      {tracks.map((track, index) => (
        <div
          key={index}
          className='px-7 border-t-[1px] border-b-[1px] border-[#E6E9EE] h-[34px] flex relative'
          style={
            tableRef.current?.scrollWidth ? { width: `${tableRef.current?.scrollWidth}px` } : {}
          }
        >
          <div className='relative w-full h-full'>
            {track.map((rec, index) => (
              <div
                key={index}
                className='h-full bg-primary hover:bg-opacity-20 bg-opacity-5 absolute top-0'
                style={{
                  width: `${(rec.end - rec.beg) / 86400 * 100}%`,
                  left: `${rec.beg / 86400 * 100}%`
                }}
                onClick={() => onAddVideo(rec)}
              />
            ))}
          </div>
          {/* <p className='text-center text-[13px] leading-[15px] text-[#6B6B6B]'>{options?.trackNames?.[index] || `Camera-${index+1}`}</p> */}
        </div>
      ))}
      <section className='flex items-center gap-2 pt-3'>
        {new Array(hoursCount).fill('').map((_, index) => (
          <div key={index} className='flex gap-[10px] items-end first:pl-7 last:pr-7'>
            <div className='flex flex-col gap-1 items-center w-[1px]'>
              <p className='text-[10px] leading-[10px] text-[#A6A6A6]'>
                {index !== 0 ? `${index}:00` : index}
              </p>
              <span className='w-[1px] max-w-[1px] h-4 bg-[#A6A6A6] block' />
            </div>
            {index + 1 !== hoursCount && (
              <>
                <span className='max-w-[1px] w-[1px] h-[10px] bg-[#E6E9EE] block' />
                <span className='max-w-[1px] w-[1px] h-[10px] bg-[#E6E9EE] block' />
                <span className='max-w-[1px] w-[1px] h-[10px] bg-[#E6E9EE] block' />
                <span className='max-w-[1px] w-[1px] h-[10px] bg-[#E6E9EE] block' />
              </>
            )}
          </div>
        ))}
      </section>
    </div>
  );
};
