'use client';
import { useCallback, useMemo, useState } from 'react';
import { Container } from '@/components/UI/Container';
import CameraGrid from '@/components/CameraGrid';
import Player from '@/components/Player';
import FullWindowComponentContextProvider from '@/contexts/FullWindowComponentContext';
import Camera from '@/components/Camera';
import { useGetRecords } from '@/queries/records';
import { IRecord } from '@/queries/records.interfaces';
import { Filters } from './Filters';
import { Timeline } from './Timeline';

export const Records = () => {
  const [isTimeLineHide, setIsTimeLineHide] = useState<boolean>(false);
  const [filters, setFilters] = useState<any>(undefined);
  const records = useGetRecords(filters)

  const [selectedRecords, setSelectedRecords] = useState<Array<IRecord | undefined>>([]);

  const handleToggleVideo = (record: IRecord) => {
    setSelectedRecords((prev) => {
      const includes = prev.some(
        (el) => el?.chn === record.chn && el?.devIdno === record.devIdno,
      );
      if (includes) {
        const index = prev.findIndex(
          (el) => el?.chn === record.chn && el?.devIdno === record.devIdno,
        );
        console.log(index)

        if(prev[index]?.beg !== record.beg) {
          const next = [...prev];
          next[index] = record;
          return next
        }


        const next = [...prev];
        next[index] = undefined;
        return next;
      } else {
        const emptyIndex = prev.findIndex((el) => !el);
        const newIndex = emptyIndex === -1 ? prev.length : emptyIndex;

        const next = [...prev];
        next[newIndex] = {...record};
        return next;
      }
    });
  }

  const [video, setVideo] = useState();
  const handleSelectVideo = useCallback((video: any) => {
    setVideo(video)
  }, [])
  
  return (
    <FullWindowComponentContextProvider>
      <Container as='section'>
        <div className='grid grid-cols-[430px,calc(100vw-550px)] gap-6'>
          <Filters onSearch={setFilters} />
          <div className='flex flex-col gap-8 w-full h-full flex-[1]'>
            <div className='flex flex-col w-full'>
              <div className='w-full h-[604px]'>
                <CameraGrid size={3}>
                  {selectedRecords.map((cam, index) =>
                    !cam ? (
                      <div key={index} />
                    ) : (
                      <Camera
                        key={index}
                        type="record"
                        record={cam}
                        deviceID={cam?.devIdno || ''}
                        chnID={cam?.chn || 0}
                        onClick={handleSelectVideo}
                        selectedVideo={video}
                      />
                      ),
                  )}
                </CameraGrid>
              </div>
              <Player video={video} onFullBlock={() => setIsTimeLineHide((prev) => !prev)} />
            </div>
            {!isTimeLineHide && <Timeline records={records.data?.files || []} onAddVideo={handleToggleVideo} />}
          </div>
        </div>
      </Container>
    </FullWindowComponentContextProvider>
  );
};
