
import { StandardAlarm } from '@/classes/StandardAlarm';
import { StandardVehicle } from '@/classes/StandardVehicle';
import { Async } from '@/components/Async/Async';
import { IBooleanField, ISelectField } from '@/components/GridButton/constants';
import { IColumn } from '@/components/Table/Table';
import { alarmNames } from '@/constants/alarms';
import { formatNumber } from '@/utils/number';

export const modal: Array<ISelectField | IBooleanField> = [
  {
    key: 'alarm_update',
    label: 'Обновлять тревоги каждые',
    defaultValue: '1',
    property: [
      {
        label: 'property1',
        value: '1',
      },
      {
        label: 'property2',
        value: '2',
      },
      {
        label: 'property3',
        value: '3',
      },
    ],
    type: 'select',
  },
];

export const data = [
  {
    title: 'Контроль',
    key: 'control',
  },
  {
    title: 'AI тревога',
    key: 'alert',
  },
  {
    title: 'Overspeed',
    key: 'overspeed',
  },
  {
    title: 'Усталость',
    key: 'fatigue',
  },
  {
    title: 'Смещение',
    key: 'offset',
  },
  {
    title: 'Зоны',
    key: 'zones',
  },
  {
    title: 'Другие',
    key: 'other',
  },
  {
    title: 'Вождение',
    key: 'driving',
  },
  {
    title: 'Медиафайлы',
    key: 'media',
  },
  {
    title: 'Система',
    key: 'system',
  },
];

export interface IRow {
  company: any;
  vehicle: StandardVehicle;
  status: any;
}

const colDefault = { className: 'min-w-[200px] text-[14px] text-center text-nowrap text-ellipsis overflow-hidden !block' };

export const tableHeadings: Record<string, IColumn<any>[]> = {
  control: [
    { ...colDefault, label: 'Госномер', component: (row: IRow) => row.vehicle.getName() },
    { ...colDefault, label: 'Компания', component: (row: IRow) => row.vehicle.getCompanyName() },
    { ...colDefault, label: 'Группировка', component: (row: IRow) => row.vehicle.getGroupName() },
    { ...colDefault, label: 'Lines in Operation', field: 'lines' },
    { ...colDefault, label: 'Время GPS', component: (row: IRow) => row.vehicle.getGpsData().gt },
    {
      ...colDefault,
      label: 'Долгота',
      field: 'lat_lon',
      component: (row: IRow) => row.vehicle.getGpsData().mlat,
    },
    {
      ...colDefault,
      label: 'Широта',
      field: 'lat_lon',
      component: (row: IRow) => row.vehicle.getGpsData().mlng,
    },
    { ...colDefault, label: 'Service Expired', field: 'service' },
    { ...colDefault, label: 'Curent Roat Type', field: 'roat_type' },
    { ...colDefault, label: 'Drive Recorder Speed', field: 'drive_record' },
    { ...colDefault, label: 'Скорость км/ч', component: (row: IRow) => row.vehicle.getGpsData().sp / 10 },
    { ...colDefault, label: 'Ограничение скорости', field: 'drive_record' },
    { ...colDefault, label: 'Дорожное ограничение скрости', field: 'drive_record' },
    { ...colDefault, label: 'Alarm', field: 'drive_record' },
    { ...colDefault, label: 'Статус', field: 'drive_record' },
    { ...colDefault, label: 'Пробег', component: (row: IRow) => formatNumber(row.vehicle.getGpsData().lc / 1000) + ' км.' },
    { ...colDefault, label: 'Пробег за сегодня', field: 'drive_record' },
    { ...colDefault, label: 'Другая информация', field: 'drive_record' },
    { ...colDefault, label: 'DriveInfo', field: 'drive_record' },
    { ...colDefault, label: 'Driver Swipe', field: 'drive_record' },
    { ...colDefault, label: 'Time', field: 'drive_record' },
    { ...colDefault, label: 'Driver Operating Time', field: 'drive_record' },
    { ...colDefault, label: 'Forward Reverse State', field: 'drive_record' },
    { ...colDefault, label: 'Empty Heavy State', field: 'drive_record' },
    { ...colDefault, label: 'Empty Reload State', field: 'drive_record' },
  ],
  alert: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  overspeed: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  fatigue: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  offset: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  zones: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  other: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  driving: [
    { ...colDefault, label: 'Alarm Detail', field: 'drive_record' },
    { ...colDefault, label: 'Обработка тревожных сигналов', field: 'drive_record' },
    { ...colDefault, label: 'Компания', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getCompanyName() },
    { ...colDefault, label: 'Госномер', component: (row: StandardAlarm[]) => row[0].getVehicle()?.getName() },
    { ...colDefault, label: 'Всего/Обработанно', component: (row: StandardAlarm[]) => `0/${row.length}` },
    { ...colDefault, label: 'Последний сигнал тревоги', component: (row: StandardAlarm[]) => alarmNames[row.at(-1)?.info.stType || -1] || row.at(-1)?.info.stType },
    { ...colDefault, label: 'Информ. тревог', field: 'drive_record' },
    { ...colDefault, label: 'Время начала', component: (row: StandardAlarm[]) => row[0].info.srcTm },
    { ...colDefault, label: 'Окончание', component: (row: StandardAlarm[]) => row.at(-1)?.info.time },
    { ...colDefault, label: 'Driver', field: 'drive_record' },
    {
      ...colDefault, label: 'Местоположение', component: (row: StandardAlarm[]) => (
        <Async
          promise={row.at(-1)?.getLocation()}
          then={(val) => <>{val.address}</>}
          loading={(<>load...</>)}
        />
      )
    },
  ],
  media: [
    { ...colDefault, label: 'Операции', field: 'drive_record' },
    { ...colDefault, label: 'Госномер', field: 'drive_record' },
    { ...colDefault, label: 'Тип файла', field: 'drive_record' },
    { ...colDefault, label: 'Канал', field: 'drive_record' },
    { ...colDefault, label: 'Reception time', field: 'drive_record' },
    { ...colDefault, label: 'Время файла', field: 'drive_record' },
    { ...colDefault, label: 'Статус', field: 'drive_record' },
    { ...colDefault, label: 'Тип тревоги', field: 'drive_record' },
    { ...colDefault, label: 'Размер MB', field: 'drive_record' },
    { ...colDefault, label: 'Расположение файла', field: 'drive_record' },
    { ...colDefault, label: 'Путь файла', field: 'drive_record' },
  ],
  system: [
    { ...colDefault, label: 'Госномер', field: 'drive_record' },
    { ...colDefault, label: 'Время', field: 'drive_record' },
    { ...colDefault, label: 'Тип тревоги', field: 'drive_record' },
    { ...colDefault, label: 'Статус', field: 'drive_record' },
    { ...colDefault, label: 'Другая информация', field: 'drive_record' },
  ]
};
