import { StandardVehicle } from '@/classes/StandardVehicle';
import { StandardDevice } from '@/classes/StandartDevice';
import { queryClient } from '@/components/ReactQueryWrapper/ReactQueryWrapper';
import { IVehicle } from '@/types/IVehicle';

export const filterByStatus = (filterStatus: string[], vehicle: IVehicle) => {
  const qClient = queryClient;
  const vehID = vehicle.dl[0].id;
  const statusesList = qClient.getQueryData(['statuses', 'list']) as any;
  const onlineList = (qClient.getQueryData(['vehicle', 'status']) as any)?.filter((el: any) => el.online === 1);


    const vehStatus = statusesList[vehID]

  const isOnline = onlineList.some((el: any) => el.did === vehID);
  const speed = false;

  const matches = filterStatus.map((fs) => {
    let match: boolean;
    const fsVal = +fs;

    const veh = new StandardVehicle(vehicle as any);

    switch (fsVal) {
      case 1: //online
        match = isOnline;
        break;
      //   case 2://Alarm (positioning valid + alarm status)
      //       match = isOnline /*&& validGps*/ && status == 3;
      //       break;
        case 3://Offline
            match = !isOnline;
            break;
      //   case 4://Idle speed (positioning valid + ACC on + stationary)
      //       match = isOnline && validStatusGps && vehicle.isIdling();
      //       break;
      //   case 5://Parking (positioning valid + ACC off + stationary)
      //       match = isOnline && validStatusGps && vehicle.isParkedNew();
      //       break;
      //   case 6://Not located
      //       match = isOnline && !validGps;
      //       break;
        case 7: //Вождение
            match = isOnline && veh.getGpsData().sp > 0;
            break;
      //   case 8://Heavy vehicle
      //       var dev = vehicle.getValidDevice();
      //       if(dev){
      //           var taxiStatus = dev.getEmptyTaxiStatus();
      //           match = isOnline && taxiStatus.hasOwnProperty("isTaxi") && taxiStatus.hasOwnProperty("isWeigthStatus");
      //       }
      //       break;
      default:
        match = true;
        break;
    }

    return match;
  });

  return matches.some((el) => !!el);
};



export const filterByDevices = (filterStatus: string[], vehicle: IVehicle) => {
  const qClient = queryClient;
  const vehID = vehicle.dl[0].id;
  const statusesList = qClient.getQueryData(['statuses', 'list']) as any;
  const onlineList = (qClient.getQueryData(['vehicle', 'status']) as any)?.filter((el: any) => el.online === 1);
  const vehStatus = statusesList[vehID]

  const matches = filterStatus.map((fs) => {
    let match: boolean;
    const fsVal = +fs;
    const devices = vehicle.dl.map((info) => new StandardDevice(info as any));

    switch (fsVal) {
        case 7:       // Видео устройство
          match = devices.some((el) => el.isVideoDevice());
          break;
        case 5:     // Трекер
          match = devices.some((el) => el.isGpsDevice());
          break;
        case -2:    // Активная безопасность
          // match = vehicle.isSafeTyVehi()
          match = false
          break;
      default:
        match = true;
        break;
    }

    return match;
  });

  return matches.some((el) => !!el);
};
