import { IBooleanField, ISelectField } from '@/components/GridButton/constants';
import {
  ITreeCameraItem,
  ITreeCompanyItem,
  ITreeItem,
  ITreeVehicleItem,
} from '@/components/TreeItem/interface';
import { ICompany } from '@/types/ICompnay';
import { IOption } from '@/types/IOption';
import { IVehicle } from '@/types/IVehicle';

export const prepareTree = (data: {
  list: {
    companys?: ICompany[];
    vehicles?: IVehicle[];
    result?: number;
  };
  onlines: Array<{
    did: string;
    online: number;
    vid: string;
  }>;
}): ITreeItem[] => {
  return (
    data.list.companys
      ?.map(
        (company) =>
          ({
            title: company.nm,
            key: 'monitoring',
            type: 'company',
            childs:
              data.list.vehicles
                ?.filter((vehicle) => vehicle.pid === company.id)
                ?.map(
                  (vehicle) =>
                    ({
                      title: vehicle.nm,
                      key: vehicle.id,
                      vehID: vehicle.nm,
                      type: 'vehicle',
                      DevIDNO: vehicle.dl?.[0].id,
                      isOnline: data.onlines.some((el) => el.online === 1 && el.vid === vehicle.nm),
                      childs: (vehicle.chnName as string).split(',').map(
                        (chn, index) =>
                          ({
                            title: `кам ${index + 1}`,
                            key: chn,
                            type: 'camera',
                            vehID: vehicle.nm,
                            DevIDNO: vehicle.dl[0].id,
                            Channel: index,
                          }) as ITreeCameraItem,
                      ),
                    }) as unknown as ITreeVehicleItem,
                ) || [],
          }) as ITreeCompanyItem,
      )
      .sort((a, b) => (b as any).childs.length - (a as any).childs.length) || []
  );
};

export const data: Array<ISelectField | IBooleanField> = [
  {
    key: 'vechicle',
    label: 'Display vechicle abbreviation',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'sort',
    label: 'Динамическая сортировка',
    defaultValue: 'false',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'status',
    label: 'Отображение статуса транспорта',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'state',
    label: 'Отображение состояния “Вперед-назад”',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'park_status',
    label: 'Показать статус парковки',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'active_sign',
    label: 'Отображать знаки активных устройств безопасности',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
  {
    key: 'license',
    label: 'Show license plate color',
    defaultValue: 'true',
    property: [
      {
        label: 'Да',
        value: 'true',
      },
      {
        label: 'Нет',
        value: 'false',
      },
    ],
    type: 'boolean',
  },
];

export const statusesOptions: IOption[] = [
  { label: 'Вождение', value: '7' },
  { label: 'В сети', value: '1' },
  { label: 'Не в сети', value: '3' },
  { label: 'Alarm', value: '2', disabled: true },
  { label: 'Стоит', value: '4', disabled: true },
  { label: 'Припаркован', value: '5', disabled: true },
  { label: 'Untargeted', value: '6', disabled: true },
  { label: 'Тяжелый грузовик', value: '8', disabled: true },
];

export const devicesOptions: IOption[] = [
  { label: 'Видео устройство', value: '7' },
  { label: 'Трекер', value: '5' },
  { label: 'Активная безопасность', value: '-2', disabled: true },
];

export const typesOptions: IOption[] = [
  { label: 'Без типа', value: '0' },
  { label: 'Опасные грузы', value: '1' },
  { label: 'Пассажирский автобус', value: '2' },
  { label: 'Маршрутое такси', value: '3' },
  { label: 'Лимузин', value: '14' },
  { label: 'Туристический', value: '12' },
  { label: 'Администрация', value: '13' },
  { label: 'Небольшой легковой автомобиль', value: '20' },
  { label: 'Такси', value: '4' },
  { label: 'Наемная', value: '18' },
  { label: 'Грузовик', value: '5' },
  { label: 'Мусоровоз', value: '6' },
  { label: 'Ассенизатор', value: '7' },
  { label: 'Бетономешалка', value: '8 ' },
  { label: 'Экскаватор', value: '9' },
  { label: 'Строительная', value: '11' },
  { label: 'Автобус', value: '15' },
  { label: 'Легковая', value: '16' },
  { label: 'Школьный автобус', value: '17' },
  { label: 'Корабль', value: '19' },
  { label: 'Customized passenger', value: '21' },
];