export const tabs = [
  { title: 'Данные суточные', key: 'day_data' },
  { title: 'Дашборд', key: 'dashboard' },
  { title: 'Рабочий стол', key: 'desktop' },
];

export const info = {
  desktop: {
    info: [
      {
        title: 'Общая сеть транспортных средств',
        key: '1',
        borderColor: 'border-[#00B3FF]',
        mock: '3000',
      },
      {
        title: 'Всего транспортных средств онлайн',
        key: 'onlineVehiCount',
        borderColor: 'border-[#2DD683]',
        mock: '1700',
      },
      { title: 'Всего компаний', key: 'companyCount', borderColor: 'border-[#FED142]', mock: '23' },
      { title: 'Ключевая сигнализация', key: '4', borderColor: 'border-[#FA8B3A]', mock: '279' },
    ],
    classNames: {
      wrapperClassname: 'h-[105px] mr-8 last:mr-0',
      contentClassname:
        'flex min-w-[432px] justify-between items-center [&_p]:text-[#AFAFAF] [&_p]:text-base [&_p]:max-w-[70%] [&_p]:text-[#AFAFAF] [&_p]:whitespace-normal [&_span]:text-[36px] [&_span]:leading-[50px] [&_span]:font-bold',
    },
  },
  day_data: {
    info: [
      { title: 'Всего Предприятий', key: 'companyCount', borderColor: 'border-[#00B3FF]', mock: 9 },
      { title: 'Все водители', key: 'driverCount', borderColor: 'border-[#2DD683]', mock: 0 },
      {
        title: 'Всего транспортных средств ',
        key: 'vehiCount',
        borderColor: 'border-[#FED142]',
        mock: 10,
      },
      {
        title: 'Сегодня транспортных средств онлайн',
        key: 'todayOnlineVehiCount',
        borderColor: 'border-[#FA8B3A]',
        mock: 5,
      },
      {
        title: 'Текущие автомобили с сигнализацией',
        key: 'alarmVehiCount',
        borderColor: 'border-[#16A8CD]',
        mock: 2,
      },
      {
        title: 'Всего транспортных средств онлайн',
        key: 'onlineVehiCount',
        borderColor: 'border-[#E74A51]',
        mock: 5,
      },
      {
        title: 'Средний пробег (км/день)',
        key: 'licheng',
        borderColor: 'border-[#9747FF]',
        mock: 43.1,
      },
      {
        title: 'Среднее время (ч/день)',
        key: 'workTime',
        borderColor: 'border-[#E2362F]',
        mock: 2.14,
        format: (val: number | string) => (+val / 3600).toFixed(2),
      },
    ],
    classNames: {
      wrapperClassname: 'h-[105px] mr-3 last:mr-0',
      contentClassname: 'min-w-[214px] flex flex-1 gap-1 justify-between',
    },
  },
  dashboard: {
    info: [
      { title: 'AI Общее количество тревог', key: 'AI_TOTAL', borderColor: 'border-[#00B3FF]' },
      { title: 'Активная безопасность', key: 'adasCount', borderColor: 'border-[#2DD683]' },
      { title: 'Ненормальное вождение ', key: 'dsmCount', borderColor: 'border-[#FED142]' },
      { title: 'BSD', key: 'bsdCount', borderColor: 'border-[#FA8B3A]' },
      { title: 'Агрессивная Езда', key: 'fdCount', borderColor: 'border-[#16A8CD]' },
      { title: 'Спутниковое позиционирование', key: 'spCount', borderColor: 'border-[#E74A51]' },
      { title: 'Интеллектуальное обнаружение', key: 'vomCount', borderColor: 'border-[#9747FF]' },
    ],
    classNames: {
      wrapperClassname: 'h-[105px] mr-5 last:mr-0',
      contentClassname:
        'min-w-[238px] flex gap-1 justify-between [&_span]:flex [&_span]:flex-col [&_span]:justify-end [&_p]:max-w-[75%] [&_p]:text-[#AFAFAF] [&_p]:whitespace-normal [&_p]:text-base [&_p]:leading-5 [&_span]:text-[36px] [&_span]:leading-[44px] [&_span]:font-bold [&_span]:text-primary',
    },
  },
};
