'use client';
import { FC, ReactElement, ReactNode, cloneElement } from 'react';
import clsx from 'clsx';
import classNames from 'classnames';

import Icon from '@/components/Icon';
import { Paper } from '@/components/Paper';
import { useFullWindowContext } from '@/contexts/FullWindowComponentContext';
import GridButton from '@/components/GridButton';

interface PaperWithGraphicProps {
  title?: string;
  className?: string;
  onWidget?: () => void;
}

export const PaperWithGraphic: FC<React.PropsWithChildren<PaperWithGraphicProps>> = ({
  children,
  title,
  className,
  onWidget,
}) => {
  const { handleToggleComponent } = useFullWindowContext();

  return (
    <Paper className={classNames(className, 'flex flex-col')}>
      <div className='flex justify-between h-[52px] gap-1'>
        <p className='text-[22px] leading-[26px] font-medium mt-2'>{title}</p>
        <div className='flex items-center gap-[7px]'>
          <GridButton data={[] as any} />

          <button
            type='button'
            className='min-w-10 min-h-10 w-10 h-10 flex justify-center items-center border-[1px] border-light_gray rounded-md'
            title='Раскрыть/Скрыть'
            onClick={() =>
              handleToggleComponent?.(
                <PaperWithGraphic
                  className={clsx(className, 'w-full h-full')}
                  onWidget={onWidget}
                  title={title}
                >
                  {cloneElement(children as ReactElement<any, string>, { height: '80%' })}
                </PaperWithGraphic>,
              )
            }
          >
            <Icon src='/images/full.svg' className='w-6 h-6 text-primary' />
          </button>
        </div>
      </div>

      {children}
    </Paper>
  );
};
