import clsx from 'clsx';
import { FC } from 'react';
import { Bar, BarChart, CartesianGrid, ResponsiveContainer, Tooltip, XAxis, YAxis } from 'recharts';
import { TotalGraphicProps } from '@/pagesComponents/Dashboard/Graphics/types';

interface SingleBarChartGraphicProps extends TotalGraphicProps {
  data: { name: string; value: number }[];
}

export const SingleBarChartGraphic: FC<SingleBarChartGraphicProps> = ({
  data,
  className,
  height = 196,
}) => {
  return (
    <ResponsiveContainer width='100%' height={height}>
      <BarChart data={data} barGap={40} className={clsx('mt-6 ml-[-30px]', className)}>
        <CartesianGrid strokeDasharray='3 3' />
        <XAxis
          dataKey='name'
          className={`[&_text]:text-[12px] [&_text]:leading-4 [&_text]:text-[#6B6B6B] [&_line]:hidden`}
          dy={10}
          fontSize={10}
          color='#6B6B6B'
        />
        <YAxis
          dataKey='value'
          className={`[&_text]:text-[12px] [&_text]:leading-4 [&_text]:text-[#6B6B6B] [&_line]:hidden`}
          fontSize={10}
          color='#6B6B6B'
        />
        <Tooltip />
        <Bar dataKey='value' fill='#01CFE7' radius={10} />
      </BarChart>
    </ResponsiveContainer>
  );
};
