import { FC } from 'react';
import { Legend, RadialBar, RadialBarChart, ResponsiveContainer, Tooltip } from 'recharts';
import { TotalGraphicProps } from '@/pagesComponents/Dashboard/Graphics/types';

interface RadialBarChartGraphicProps extends TotalGraphicProps {
  data: { name: string; uv: number; pv: number; fill: string }[];
}

export const RadialBarChartGraphic: FC<RadialBarChartGraphicProps> = ({
  data,
  height = 179,
  className,
}) => {
  return (
    <ResponsiveContainer width='100%' height={height} className={className}>
      <RadialBarChart data={data}>
        <RadialBar dataKey='uv' />
        <Legend
          iconSize={10}
          width={120}
          height={140}
          layout='vertical'
          verticalAlign='middle'
          align='right'
        />
        <Tooltip />
      </RadialBarChart>
    </ResponsiveContainer>
  );
};
