import clsx from 'clsx';
import { FC } from 'react';
import { Cell, Pie, PieChart, ResponsiveContainer } from 'recharts';
import { TotalGraphicProps } from '@/pagesComponents/Dashboard/Graphics/types';

interface PieChartGraphicProps extends TotalGraphicProps {
  data: { value: number; title: string; colorPieCell: string }[];
  graphicClassName?: string;
  listItemClassName?: string;
  withPercentVisible?: boolean;
}

export const PieChartGraphic: FC<PieChartGraphicProps> = ({
  data,
  className,
  listItemClassName,
  withPercentVisible,
  graphicClassName,
  height = 183,
}) => {
  return (
    <div className={clsx(className, 'flex justify-between gap-5 h-full')}>
      <ResponsiveContainer width='100%' height={height}>
        <PieChart className={graphicClassName}>
          <Pie data={data} dataKey='value' outerRadius={'80%'} innerRadius={'60%'} fill='#8884d8'>
            {data.map((entry) => (
              <Cell key={`cell-${entry.title}`} fill={entry.colorPieCell} stroke='none' />
            ))}
          </Pie>
        </PieChart>
      </ResponsiveContainer>

      <ul>
        {data.map((item) => (
          <li
            key={item.title}
            className={clsx(listItemClassName, 'flex items-center gap-4', {
              'justify-between': withPercentVisible,
            })}
          >
            {withPercentVisible ? (
              <div className='flex items-center gap-4'>
                <span
                  className='min-w-3 min-h-3 w-3 h-3 rounded-[50%]'
                  style={{ background: item.colorPieCell }}
                />
                <p className='text-sm leading-5'>{item.title}</p>
              </div>
            ) : (
              <>
                <span
                  className='min-w-3 min-h-3 w-3 h-3 rounded-[50%]'
                  style={{ background: item.colorPieCell }}
                />
                <p className='text-sm leading-5'>{item.title}</p>
              </>
            )}

            {withPercentVisible && <p className='text-sm font-bold'>{item.value}%</p>}
          </li>
        ))}
      </ul>
    </div>
  );
};
