'use client';
import clsx from 'clsx';
import { FC } from 'react';
import { Bar, BarChart, Cell, ResponsiveContainer, XAxis, YAxis } from 'recharts';
import { TotalGraphicProps } from '@/pagesComponents/Dashboard/Graphics/types';
import { pieColors } from '@/constants/pie';

interface HorizontalBarChartGraphicProps<T> extends TotalGraphicProps {
  data: T[];
  yKey: keyof T;
  xKey: keyof T;
  yFormat?: (value: any, index: number) => string;
}

export const HorizontalBarChartGraphic = <T extends object>({
  data,
  height = 186,
  className,
  yKey,
  xKey,
  yFormat
}: HorizontalBarChartGraphicProps<T>) => {
  return (
    <ResponsiveContainer width='100%' height={height}>
      <BarChart
        data={data}
        layout='vertical'
        barCategoryGap={36}
        className={clsx(className, 'ml-[-100px]')}
      >
        <XAxis type='number' color='#6B6B6B' fontSize={12} dy={16} />
        <YAxis type='category' minTickGap={0} width={150} dataKey={yKey as string} color='#6B6B6B' fontSize={12} tickFormatter={yFormat} />

        <Bar dataKey={xKey as string} radius={4}>
          {data.map((item, index) => (
            <Cell key={index} fill={pieColors[index]} />
          ))}
        </Bar>
      </BarChart>
    </ResponsiveContainer>
  );
};
