'use client';
import { FC } from 'react';
import {
  Area,
  AreaChart,
  CartesianGrid,
  ResponsiveContainer,
  Tooltip,
  XAxis,
  YAxis,
} from 'recharts';
import { Poppins } from 'next/font/google';
import { TotalGraphicProps } from '@/pagesComponents/Dashboard/Graphics/types';

const poppins = Poppins({ weight: ['100', '200', '300', '400'], subsets: ['latin'] });

interface AreaChartGraphicProps extends TotalGraphicProps {
  data: {
    name: string;
    uv: number;
    pv: number;
    amt: number;
  }[];
}

export const AreaChartGraphic: FC<AreaChartGraphicProps> = ({ data, height = 256, className }) => {
  return (
    <ResponsiveContainer width='100%' height={height}>
      <AreaChart data={data} className={className}>
        <defs>
          <linearGradient id='colorUv' x1='0' y1='0' x2='0' y2='1'>
            <stop offset='5%' stopColor='#13DB9D' stopOpacity={0.8} />
            <stop offset='95%' stopColor='#13DB9D' stopOpacity={0} />
          </linearGradient>
          <linearGradient id='colorPv' x1='0' y1='0' x2='0' y2='1'>
            <stop offset='5%' stopColor='#4CBAFB' stopOpacity={0.8} />
            <stop offset='95%' stopColor='#4CBAFB' stopOpacity={0} />
          </linearGradient>
        </defs>
        <XAxis
          dataKey='name'
          className={`mt-5 [&_text]:text-[10px] [&_text]:leading-[15px] [&_text]:text-[#ACACAC] ${poppins.className}`}
        />
        <CartesianGrid strokeDasharray='3 3' />
        <Tooltip />
        <Area
          type='monotone'
          dataKey='uv'
          stroke='#13DB9D'
          fillOpacity={1}
          fill='url(#colorUv)'
          strokeWidth={3}
        />
        <Area
          type='monotone'
          dataKey='pv'
          stroke='#4CBAFB'
          fillOpacity={1}
          fill='url(#colorPv)'
          strokeWidth={3}
        />
      </AreaChart>
    </ResponsiveContainer>
  );
};
