import classNames from 'classnames';
import { BarChartGraphic } from '@/pagesComponents/Dashboard/Graphics/BarChartGraphic';
import { AreaChartGraphic } from '@/pagesComponents/Dashboard/Graphics/AreaChartGraphic/AreaChartGraphic';
import { SingleAreaChartGraphic } from '@/pagesComponents/Dashboard/Graphics/SingleAreaChartGraphic';
import { PieChartGraphic } from '@/pagesComponents/Dashboard/Graphics/PieChartGraphic';
import { PaperWithGraphic } from '@/pagesComponents/Dashboard/PaperWithGraphic';
import { HorizontalBarChartGraphic } from '@/pagesComponents/Dashboard/Graphics/HorizontalBarChartGraphic';
import { info } from '@/pagesComponents/Dashboard/constants';
import { DashboardCart } from '@/pagesComponents/Dashboard/DashboardCart';
import {
  pieChartGraphic,
  dataBarChartGraphic,
  dataDoubleAreaChart,
  dataSingleGraphic,
  graphicHeadings,
  dataHorizontalBarChartGraphic,
} from './constants';

import './styles.css';

interface IProps {
  days: string;
}

export const Desktop: React.FC<IProps> = ({
  days
}) => {
  return (
    <div>
      <div
        className={`mt-[30px] flex w-full justify-between items-center overflow-x-auto whitespace-nowrap scrollbar`}
      >
        <>
          {info.desktop.info?.map((inf) => {
            return (
              <DashboardCart
                key={inf.key}
                title={inf.title}
                value={inf.mock}
                className={classNames(info.day_data.classNames.wrapperClassname)}
                contentClassName={`${info.day_data.classNames.contentClassname} ${inf.borderColor}`}
              />
            );
          })}
        </>
      </div>

      <section className='mt-7 grid grid-cols-2 gap-8'>
        <PaperWithGraphic title='Региональная статистика транспортных средств'>
          <AreaChartGraphic data={dataDoubleAreaChart} className='mt-6' />
        </PaperWithGraphic>
        <PaperWithGraphic title='Статистика транспортных предприятий(Топ-3)'>
          {/* <BarChartGraphic data={dataBarChartGraphic} className='mt-6' /> */}
        </PaperWithGraphic>
      </section>

      <ul className='mt-7 grid grid-cols-4 gap-8'>
        {graphicHeadings.map((heading) => (
          <li key={heading.key} className={`rounded-lg ${heading.bgWrapper}`}>
            <div
              className={`flex items-center justify-between pl-[45px] pr-[60px] ${heading.bg || ''}`}
            >
              <p className={`text-[22px] leading-[26px] ${heading.textColor} font-medium`}>
                {heading.name}
              </p>
              <p className={`font-bold text-4xl leading-[50px] ${heading.textColor}`}>
                {heading.mock}
              </p>
              {/* todo: заменить на получение данных по ключу из объекта, приходящего с бэка */}
            </div>
          </li>
        ))}
      </ul>

      <section className='mt-7 grid grid-cols-4 gap-8'>
        <PaperWithGraphic title='Распределение сигналов тревоги'>
          <PieChartGraphic data={pieChartGraphic} className='mt-2' />
        </PaperWithGraphic>
        <PaperWithGraphic title='Статистика по сигналам тревоги'>
          <div className='flex-1 flex items-center'>
            {/* <SingleAreaChartGraphic
              data={dataSingleGraphic}
              color='green'
              className='mt-4 singleAreaGraphic'
              id='statisticBySignal'
            /> */}
          </div>
        </PaperWithGraphic>
        <PaperWithGraphic title='Онлайн-компаратор тарифов'>
          <div className='flex-1 flex items-center'>
            {/* <SingleAreaChartGraphic
              data={dataSingleGraphic}
              className='mt-4 singleAreaGraphic'
              id='onlineComparator'
            /> */}
          </div>
        </PaperWithGraphic>
        <PaperWithGraphic title='Рейтинг сигналов тревоги (топ-3)'>
          {/* <HorizontalBarChartGraphic data={dataHorizontalBarChartGraphic} className='mt-[6px]' /> */}
        </PaperWithGraphic>
      </section>
    </div>
  );
};
