'use client';
import Icon from '@/components/Icon';
import { Paper } from '@/components/Paper';
import { useDashboardDayData } from '@/queries/dashboard';
import { useFullWindowContext } from '@/contexts/FullWindowComponentContext';
import { listData } from './constants';

export const DataListBlock = () => {
  const handleToggleComponent = useFullWindowContext()?.handleToggleComponent;
  const {data, isLoading: dashboardLoading } = useDashboardDayData({
    searchDays: 6,
    vehiclesStatus: 0
  })

  return (
    <Paper className='w-full'>
      <div className='flex items-center gap-[7px] justify-end mb-[6px]'>
        <button
          type='button'
          className='mr-1 min-w-[30px] min-h-[30px] w-[30px] h-[30px] flex justify-center items-center border-[1px] border-light_gray rounded-md'
        >
          <Icon src='/images/icons/icon-widget.svg' className='w-4 h-4 text-primary' />
        </button>
        <button
          type='button'
          className='min-w-[30px] min-h-[30px] w-[30px] h-[30px] flex justify-center items-center border-[1px] border-light_gray rounded-md'
          onClick={() => handleToggleComponent?.(<DataListBlock />)}
        >
          <Icon src='/images/full.svg' className='w-4 h-4 text-primary' />
        </button>
      </div>

      <ul className='flex flex-col gap-6'>
        {listData.map((listItem) => (
          <li key={listItem.key} className='flex items-center gap-2 justify-between'>
            <p className='text-sm leading-4 font-medium text-[#AFAFAF] max-w-[72%]'>
              {listItem.name}
            </p>
            <p className='text-2xl leading-7 font-bold text-primary'>
              {listItem.key ? (data?.instrumentPanel?.info as any)?.[listItem.key] : listItem.mock}
            </p>
          </li>
        ))}
      </ul>
    </Paper>
  );
};
