import clsx from 'clsx';
import { FC, ReactNode } from 'react';

interface DashboardCartProps {
  className?: string;
  contentClassName?: string;
  title: string;
  value: ReactNode;
}

export const DashboardCart: FC<DashboardCartProps> = ({
  className,
  contentClassName,
  title,
  value,
}) => {
  return (
    <div className={clsx(className, 'border-[1px] border-[#E6E9EE] bg-white rounded-xl flex-1')}>
      <div
        className={clsx(
          contentClassName,
          'pt-[14px] pr-[9px] pb-2 pl-6 border-l-[6px] rounded-tl-[12px] rounded-bl-[12px] h-full',
        )}
      >
        <p className='max-w-[75%] text-[#AFAFAF] whitespace-normal text-base leading-5'>{title}</p>
        <span className='flex flex-col justify-end text-[36px] leading-[44px] font-bold text-primary'>{value}</span>
      </div>
    </div>
  );
};
