import clsx from 'clsx';
import { DetailedHTMLProps, FC, ReactNode, TextareaHTMLAttributes } from 'react';

interface TextareaProps
  extends DetailedHTMLProps<TextareaHTMLAttributes<HTMLTextAreaElement>, HTMLTextAreaElement> {
  label?: string | ReactNode;
}

export const Textarea: FC<TextareaProps> = ({ className, children, label, ...rest }) => {
  return (
    <div>
      {label && <p className='text-base leading-4 mb-1'>{label}</p>}
      <textarea
        className={clsx(
          className,
          'p-4 w-full border-[1px] transition-colors duration-300 border-light_gray rounded-lg focus:border-primary outline-none resize-none',
        )}
        {...rest}
      >
        {children}
      </textarea>
    </div>
  );
};
