import clsx from 'clsx';
import { FC } from 'react';
import { IOption } from '@/types/IOption';

interface IRadioProps extends IOption {
  isActive: boolean;
  onChange?: (_value: IOption['value']) => void;
  className?: string;
}

export const Radio: FC<IRadioProps> = ({ isActive, label, value, className, onChange }) => {
  return (
    <div
      className={clsx(className, 'flex items-center')}
      role='button'
      onClick={() => onChange && onChange(value)}
    >
      <button
        className={clsx(
          'w-6 h-6 rounded-[50%] border-[1px] flex justify-center items-center transition-colors duration-300',
          isActive ? 'border-primary' : 'border-light_gray',
        )}
        type='button'
      >
        {isActive && <span className='w-4 h-4 rounded-[50%] bg-primary block' />}
      </button>
      <p className='text-text text-base leading-5 ml-[7px]'>{label}</p>
    </div>
  );
};
