import clsx from 'clsx';
import { DetailedHTMLProps, FC, InputHTMLAttributes, ReactNode } from 'react';
import InputMask, { Props as ReactInputMaskProps } from 'react-input-mask';

interface IInputProps
  extends DetailedHTMLProps<InputHTMLAttributes<HTMLInputElement>, HTMLInputElement> {
  inputClassName?: string;
  label?: string | ReactNode;
  icon?: ReactNode;
  error?: boolean;
  wrapperInputClassName?: string;
  mask?: string;
}
export const Input: FC<IInputProps & Omit<ReactInputMaskProps, 'mask'>> = ({
  className,
  label,
  inputClassName,
  icon,
  error,
  wrapperInputClassName,
  mask,
  maskChar,
  ref,
  ...rest
}) => {
  return (
    <div className={clsx(className, 'w-full')}>
      {label && <p className='text-base leading-5 mb-1 text-[#011844]'>{label}</p>}
      <div
        className={clsx(
          'w-full h-12 bg-white rounded-lg border-[1px] border-light_gray transition-all duration-300 focus-within:border-[#E0EFFE] overflow-hidden',
          wrapperInputClassName,
          icon && 'flex items-center justify-between',
          error && 'border-red-500 focus-within:border-red-500',
        )}
      >
        {mask ? (
          <InputMask
            mask={mask}
            maskChar={maskChar}
            className={clsx(
              inputClassName,
              'w-full h-full py-3 px-4 outline-0 text-[#5A5A5D] text-sm leading-[14px] focus:placeholder:opacity-0 autofill:bg-white autofill:rounded-lg placeholder:text-base placeholder:leading-[19px]',
            )}
            {...rest}
          />
        ) : (
          <input
            className={clsx(
              inputClassName,
              'w-full h-full py-3 px-4 outline-0 text-[#5A5A5D] text-sm leading-[14px] focus:placeholder:opacity-0 autofill:bg-white autofill:rounded-lg placeholder:text-base placeholder:leading-[19px]',
            )}
            ref={ref}
            {...rest}
          />
        )}

        {icon && icon}
      </div>
    </div>
  );
};
