import { FC } from 'react';

interface DownloadPhotoInputProps {
  label?: string;
  text?: string;
  className?: string;
  id: string;
}

const DownloadPhotoInput: FC<DownloadPhotoInputProps> = ({
  className,
  label,
  text = 'Выберите изображение',
  id,
}) => {
  return (
    <div className={className}>
      {label && <p className='text-base leading-4 mb-1'>{label}</p>}
      <label
        className='h-[56px] border border-primary flex justify-center items-center rounded-lg cursor-pointer'
        htmlFor={id}
      >
        <p className='text-[14px] leading-[14px] font-medium text-primary'>{text}</p>
        <input
          type='file'
          id={id}
          className='absolute top-0 left-0 w-full opacity-0 cursor-pointer'
        />
      </label>
    </div>
  );
};

export default DownloadPhotoInput;
