import ReactDatepicker, { registerLocale, ReactDatePickerProps } from 'react-datepicker';
import 'react-datepicker/dist/react-datepicker.css';
import './Datepicker.css';
import { ru } from 'date-fns/locale/ru';
import { format } from 'date-fns';
import { FC } from 'react';
import clsx from 'clsx';
import Icon from '@/components/Icon';
registerLocale('ru', ru);

export interface IDatePickerProps extends ReactDatePickerProps {}

export const Datepicker: FC<IDatePickerProps> = ({ onChange, open, ...rest }) => {
  const today = new Date();

  const isDisabled = (date: Date) => {
    return date > today ? 'react-datepicker__day--disabled' : '';
  };

  return (
    <div className='w-full'>
      <ReactDatepicker
        onChange={onChange}
        className={clsx('w-full', open && 'hidden')}
        calendarClassName='!rounded-lg !border-[#EEEEEE] py-4 px-[10px] w-full datePicker'
        renderCustomHeader={(params) => {
          return (
            <div className='flex items-center gap-[35px] justify-center'>
              <button type='button' onClick={() => params.decreaseYear()}>
                <Icon
                  src='/images/icons/icon-double-chevron-left.svg'
                  className='w-[11px] h-[14px] text-primary'
                />
              </button>
              <button type='button' onClick={() => params.decreaseMonth()}>
                <Icon
                  src='/images/icons/icon-chevron-left.svg'
                  className='w-[11px] h-[14px] text-primary'
                />
              </button>
              <p className='text-[22px] leading-[26px] text-[#15223C] font-medium capitalize'>
                {format(params.date, 'LLLL', { locale: ru })}
              </p>
              <button type='button' onClick={() => params.increaseMonth()}>
                <Icon
                  src='/images/icons/icon-chevron-right.svg'
                  className='w-[11px] h-[14px] text-primary'
                />
              </button>
              <button type='button' onClick={() => params.increaseYear()}>
                <Icon
                  src='/images/icons/icon-double-chevron-right.svg'
                  className='w-[11px] h-[14px] text-primary'
                />
              </button>
            </div>
          );
        }}
        dayClassName={isDisabled}
        open={open}
        locale='ru'
        {...rest}
      />
    </div>
  );
};
