import clsx from 'clsx';
import { FC, ReactNode } from 'react';

interface IContainerProps {
  children: ReactNode;
  className?: string;
  as?: 'div' | 'section';
}

export const Container: FC<IContainerProps> = ({ children, as: Tag = 'div', className }) => {
  return (
    <Tag className={clsx(className, 'block mx-auto my-0 max-w-[1820px] container:px-4')}>
      {children}
    </Tag>
  );
};
