import { FC } from 'react';
import clsx from 'clsx';
import { IOption } from '@/types/IOption';
import Icon from '@/components/Icon';

interface ICheckboxProps extends Pick<IOption, 'value'> {
  isActive: boolean;
  onChange?: (_value: IOption['value']) => void;
  className?: string;
  wrapperClassName?: string;
  label?: string;
}

export const Checkbox: FC<ICheckboxProps> = ({
  isActive,
  label,
  value,
  wrapperClassName,
  className,
  onChange,
}) => {
  return (
    <div
      className={clsx(wrapperClassName, 'flex items-center')}
      role='button'
      onClick={() => onChange?.(value)}
    >
      <button
        className={clsx(
          className,
          'w-6 h-6 rounded border-[1px] flex justify-center items-center transition-colors duration-300',
          isActive ? 'border-primary bg-primary' : 'border-light_gray bg-white',
        )}
        type='button'
      >
        {isActive && (
          <Icon src='/images/icons/icon-check-mark.svg' className='w-[16px] h-[16px] text-white' />
        )}
      </button>
      {label && <p className='text-text text-base leading-5 ml-[7px]'>{label}</p>}
    </div>
  );
};
