'use client';
import { FC, ReactNode, useState } from 'react';
import clsx from 'clsx';
import Icon from '@/components/Icon';

interface AccordionProps {
  className?: string;
  children: ReactNode;
  title: string | ReactNode;
  open?: boolean;
  defaultOpen?: boolean;
}

const Accordion: FC<AccordionProps> = ({ children, title, className, open, defaultOpen }) => {
  const [isAccoridionOpen, setIsAccordionOpen] = useState<boolean>(defaultOpen || false);

  const _open = open || isAccoridionOpen;

  return (
    <div className={className}>
      <div
        role='button'
        className='p-5 pl-8 flex items-center justify-between bg-[#EBEBEB]'
        onClick={() => setIsAccordionOpen((prev) => !prev)}
      >
        <p className='text-[24px] leading-6 font-medium'>{title}</p>
        <Icon
          src='images/icons/icon-chevron-down.svg'
          className={clsx(
            'w-[10px] h-[5px] min-w-[10px] min-h-[5px] duration-300 transition-transform',
            {
              'rotate-180': _open,
            },
          )}
        />
      </div>
      {_open && <div className='accordion'>{children}</div>}
    </div>
  );
};

export default Accordion;
