export interface ITreeCameraItem {
  type: 'camera';
  key: string | number;
  title: string;

  vehID: string;
  DevIDNO: string;
  Channel: number;
  childs?: ITreeItem[];
}

export interface ITreeVehicleItem {
  type: 'vehicle';
  key: string;
  title: string;
  vehID: string;
  isOnline: boolean;
  DevIDNO?: string;

  childs?: ITreeItem[];
}

export interface ITreeCompanyItem {
  type: 'company';
  key: string;
  title: string;

  childs?: ITreeVehicleItem[];
}


export type ITreeItem =
  | ITreeCameraItem
  | ITreeVehicleItem
  | ITreeCompanyItem;
