'use client';
import clsx from 'clsx';

interface IClasses {
  root?: string;
  tab?: string;
}

export interface ITab {
  title: string;
  key: string;
}

interface IProps {
  classes?: IClasses;
  tabs: ITab[];
  value: string;
  onChange: (_key: string) => void;
}

const Tabs: React.FC<IProps> = ({ classes = {}, tabs, value, onChange }) => {
  return (
    <div className={clsx('flex gap-5', classes.root)}>
      {tabs.map((tab) => {
        const isActive = value === tab.key;
        return (
          <button
            key={tab.key}
            type='button'
            onClick={() => onChange(tab.key)}
            className={clsx(
              'pb-1 border-b-[2px] transition-colors',
              classes.tab,
              isActive ? 'border-primary' : 'border-light_gray',
            )}
          >
            <span
              className={clsx(
                'text-sm leading-4 text-center transition-colors duration-300',
                isActive ? 'text-primary font-bold' : 'text-[#011844]',
              )}
            >
              {tab.title}
            </span>
          </button>
        );
      })}
    </div>
  );
};

export default Tabs;
