'use client';

import React, { FC } from 'react';
import clsx from 'clsx';

interface IClasses {
  root?: string;
  image?: string;
}

interface IProps {
  classes?: IClasses;
  onClick?: () => void;
}

const SquareButton: FC<React.PropsWithChildren<IProps>> = ({ classes = {}, children, onClick }) => {
  return (
    <div
      onClick={onClick}
      role='button'
      className={clsx(
        'border-[1px] border-light_gray rounded-lg flex justify-center items-center cursor-pointer',
        classes.root,
      )}
    >
      {children}
    </div>
  );
};

export default SquareButton;
